PR .= ".mlinux3"

SRC_URI += " file://ntpd-default \
    file://ntp.conf.patch;patchdir=.. \
    file://ntpd-init.patch;patchdir=.. \
    file://logtime.patch \
		"
FILESEXTRAPATHS_prepend := "${THISDIR}/files:"

RDEPENDS_${PN} += "bash"

python do_patch_prepend () {
    import os
}

do_install_append() {
    install -d ${D}${sysconfdir}/default
    install -m 0644 ${WORKDIR}/ntpd-default ${D}${sysconfdir}/default/ntpd.default

    drdir=${D}${localstatedir}/lib/ntp
    install -d -m 0755 -p ${drdir}
    drfile="${drdir}/ntp.drift"
    touch ${drfile}
    chmod 664 ${drfile}
    chown -R ntp:ntp ${drdir}
}
pkg_postinst_${PN}_append() {
    update-alternatives --install ${sysconfdir}/default/ntpd ntpd-defaults ${sysconfdir}/default/ntpd.default 10
}

pkg_postrm_${PN}_append() {
    update-alternatives --remove ntpd-defaults ${sysconfdir}/default/ntpd.default
}
FILES_${PN} += "${sysconfdir}/default/ntpd.default ${localstatedir}/lib/*"
CONFFILES_${PN} += "${sysconfdir}/default/ntpd.default"
